!!ARBvp1.0
# default_shader__OVERALLALPHA.vsh

TEMP r0;
PARAM c[12] = { program.env[0..11] };
PARAM c20 = {0.0, 1.0, 0.5, 2.0};

ATTRIB v0 = vertex.position;
ATTRIB v1 = vertex.normal;
ATTRIB v2 = vertex.texcoord[0];

ALIAS oPos = result.position;
ALIAS oD0 = result.color.primary;
ALIAS oT0 = result.texcoord[0];
ALIAS oT1 = result.texcoord[1];

# transform position
DP4 oPos.x, v0, c[0];
DP4 oPos.y, v0, c[1];
DP4 oPos.z, v0, c[2];
DP4 oPos.w, v0, c[3];

# normal dot light
DP3 r0.x, v1, c[8];
MAX r0.x, r0.x, c20.x;

# Set alpha to intrinsic value
MOV r0.w, c[11].w;

# Modulate with sun color
MUL r0.xyz, c[9], r0.x;

# Add ambient color
ADD r0, r0, c[10];

# Cap out at 1.0
MIN oD0, r0, c20.yyyy;

# Use directly texcoord0
MOV oT0.xy, v2;
MOV oT1.xy, v2;

END
